#include <stdio.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <syscall_thunk.h>
#include <errno.h>

int	do_olduname(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    struct x86_oldold_utsname *u = ARG_TO_POINTER(a0);
    struct utsname au;
    
    retval = uname(&au);
    if(retval == 0) {
	memset(u, 0, sizeof(struct x86_oldold_utsname));
	strncpy(u->sysname, au.sysname, 8);
	strncpy(u->nodename, au.nodename, 8);
	strncpy(u->release, au.release, 8);
	strncpy(u->version, au.version, 8);
	strncpy(u->machine, au.machine, 8);
	return(retval);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}

int	do_uname(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    struct x86_old_utsname *u = ARG_TO_POINTER(a0);
    struct utsname au;
    
    retval = uname(&au);
    if(retval == 0) {
	memset(u, 0, sizeof(struct x86_old_utsname));
	strncpy(u->sysname, au.sysname, 64);
	strncpy(u->nodename, au.nodename, 64);
	strncpy(u->release, au.release, 64);
	strncpy(u->version, au.version, 64);
	strncpy(u->machine, au.machine, 64);
	return(retval);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}

int	do_newuname(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    struct x86_new_utsname *u = ARG_TO_POINTER(a0);
    struct utsname au;
    
    retval = uname(&au);
    if(retval == 0) {
	memset(u, 0, sizeof(struct x86_new_utsname));
	strncpy(u->sysname, au.sysname, 64);
	strncpy(u->nodename, au.nodename, 64);
	strncpy(u->release, au.release, 64);
	strncpy(u->version, au.version, 64);
	strncpy(u->machine, au.machine, 64);
	strncpy(u->machine, au.domainname, 64);
	return(retval);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}

